"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initForElectronRenderer = exports.launchSafeBrowsingAndExit = void 0;
var electron_1 = require("electron");
var commands_1 = require("./commands");
var electron_channels_1 = require("./electron-channels");
var utils_1 = require("./utils");
var launchSafeBrowsingAndExit = function () {
    utils_1.launchSafeBrowsing();
    var window = electron_1.remote.getCurrentWindow();
    window.close();
};
exports.launchSafeBrowsingAndExit = launchSafeBrowsingAndExit;
var initForElectronRenderer = function (options) {
    var onStateChangeListener = function (_, state) {
        options.onStateChange(state);
    };
    electron_1.ipcRenderer.on(electron_channels_1.Channels.contentFilteringOnStateChange, onStateChangeListener);
    var onBlockedContentListener = function (_, blockedContentInfo) {
        options.onBlockedContent(blockedContentInfo);
    };
    electron_1.ipcRenderer.on(electron_channels_1.Channels.contentFilteringOnBlockedContent, onBlockedContentListener);
    electron_1.ipcRenderer.send(electron_channels_1.Channels.contentFilteringOnRendererInit);
    return {
        launchSafeBrowsing: utils_1.launchSafeBrowsing,
        launchGhostpress: function () {
            /* noop on renderer */
        },
        terminateGhostpress: function () {
            /* noop on renderer */
        },
        getOsName: utils_1.getOsName,
        activateNativeService: function () {
            electron_1.ipcRenderer.send(electron_channels_1.Channels.contentFilteringCommand, commands_1.commandActivateNativeService());
        },
        setBlockedCategories: function (categories) {
            electron_1.ipcRenderer.send(electron_channels_1.Channels.contentFilteringCommand, commands_1.commandSetBlockedCategories(categories));
        },
        setWhitelistedDomains: function (domains) {
            electron_1.ipcRenderer.send(electron_channels_1.Channels.contentFilteringCommand, commands_1.commandSetWhitelistedDomains(domains));
        },
        setLicenseExpirationDate: function (when) {
            electron_1.ipcRenderer.send(electron_channels_1.Channels.contentFilteringCommand, commands_1.commandSetLicenseExpirationTimestamp(when));
        },
        startFiltering: function () {
            electron_1.ipcRenderer.send(electron_channels_1.Channels.contentFilteringCommand, commands_1.commandStartFiltering());
        },
        stopFiltering: function () {
            electron_1.ipcRenderer.send(electron_channels_1.Channels.contentFilteringCommand, commands_1.commandStopFiltering());
        },
        updateTo: function (updateFilePath) {
            electron_1.ipcRenderer.send(electron_channels_1.Channels.contentFilteringCommand, commands_1.commandUpdateTo(updateFilePath));
        },
        unload: function () {
            return new Promise(function (resolve, _) {
                electron_1.ipcRenderer.removeListener(electron_channels_1.Channels.contentFilteringOnStateChange, onStateChangeListener);
                electron_1.ipcRenderer.removeListener(electron_channels_1.Channels.contentFilteringOnBlockedContent, onBlockedContentListener);
                resolve();
            });
        },
    };
};
exports.initForElectronRenderer = initForElectronRenderer;
